<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];

// Pega dados da URL
$conta_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$mes = isset($_GET['mes']) ? (int)$_GET['mes'] : date('m');
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');

// Busca a conta fixa
$stmt = $pdo->prepare("SELECT * FROM contas_fixas WHERE id=? AND usuario_id=?");
$stmt->execute([$conta_id, $usuario_id]);
$conta = $stmt->fetch();

if(!$conta){
    die("Conta fixa não encontrada.");
}

// Se confirmou pagamento
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $data_pagamento = $_POST['data_pagamento'] ?? date('Y-m-d');
    $valor_pago = $_POST['valor_pago'] ?? $conta['valor'];
    $descricao_pagamento = $_POST['descricao_pagamento'] ?? '';
    $mesReferencia = "$ano-$mes-01";

    // Inserir na tabela de pagamentos
    $stmtInsert = $pdo->prepare("
        INSERT INTO contas_fixas_pagamentos 
        (conta_id, mes_referencia, data_pagamento, valor_pago, descricao) 
        VALUES (?,?,?,?,?)
    ");
    $stmtInsert->execute([$conta_id, $mesReferencia, $data_pagamento, $valor_pago, $descricao_pagamento]);

    // Lançar no caixa como saída
    $stmtMov = $pdo->prepare("
        INSERT INTO movimentos 
        (usuario_id, tipo, descricao, valor, data_movimento) 
        VALUES (?,?,?,?,?)
    ");
    $stmtMov->execute([$usuario_id, 'saida', 'Pagamento: '.$conta['descricao'].' - '.$descricao_pagamento, $valor_pago, $data_pagamento]);

    header("Location: dashboard.php?mes=$mes&ano=$ano");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <title>Registrar Pagamento - Livro Caixa</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body { font-family: Arial,sans-serif; background:#f4f4f4; margin:0; padding:0; }
        .container { max-width: 800px; margin: 30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
        h1 { color:#333; }
        nav { margin-bottom:20px; }
        nav a { margin-right:15px; text-decoration:none; color:#007bff; font-weight:bold;}
        nav a:hover { text-decoration:underline; }
        form { margin-top:20px; }
        label { display:block; margin:10px 0 5px; font-weight:bold; }
        input { width:100%; padding:8px; border:1px solid #ccc; border-radius:5px; }
        button { margin-top:15px; padding:10px 15px; background:#28a745; color:#fff; border:none; border-radius:5px; cursor:pointer; font-size:1em; }
        button:hover { background:#218838; }
        .info { background:#f8f9fa; padding:10px; border:1px solid #ddd; border-radius:5px; margin-bottom:20px; }
    </style>
</head>
<body>
<div class="container">
    <h1>Registrar Pagamento</h1>
    <nav>
        <a href="dashboard.php?mes=<?= $mes ?>&ano=<?= $ano ?>">Dashboard</a>
        <a href="contas_fixas.php">Contas Fixas</a>
        <a href="logout.php">Sair</a>
    </nav>

    <div class="info">
        <p><strong>Conta:</strong> <?= htmlspecialchars($conta['descricao']) ?></p>
        <p><strong>Valor previsto:</strong> R$ <?= number_format($conta['valor'],2,',','.') ?></p>
        <p><strong>Referência:</strong> <?= str_pad($mes,2,'0',STR_PAD_LEFT) ?>/<?= $ano ?></p>
    </div>

    <form method="POST">
        <label>Data do Pagamento:</label>
        <input type="date" name="data_pagamento" value="<?= date('Y-m-d') ?>" required>

        <label>Valor Pago:</label>
        <input type="number" step="0.01" name="valor_pago" value="<?= $conta['valor'] ?>" required>

 <label>Descrição do Pagamento:</label>
<textarea name="descricao_pagamento" placeholder="Ex: Descrição do pagamento" maxlength="2000" rows="4" required></textarea>


        <button type="submit">Confirmar Pagamento</button>
    </form>
</div>
</body>
</html>
