<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$msg = '';

if(isset($_POST['salvar'])){
    $tipo = $_POST['tipo'];
    $descricao = trim($_POST['descricao']);
    $valor = floatval(str_replace(',','.',$_POST['valor']));
    $data_movimento = $_POST['data_movimento'];
    $meio_pagamento = $_POST['meio_pagamento'] ?? null;

    $stmt = $pdo->prepare("INSERT INTO movimentos (usuario_id, tipo, descricao, valor, data_movimento, meio_pagamento) 
                           VALUES (?,?,?,?,?,?)");
    $stmt->execute([$usuario_id, $tipo, $descricao, $valor, $data_movimento, $meio_pagamento]);

    $msg = "Movimento registrado com sucesso!";
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Registrar Movimento</title>
<link rel="stylesheet" href="css/style.css">
<style>
.container { max-width:600px; margin:30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
h1 { text-align:center; margin-bottom:20px; }
form label { display:block; margin-top:15px; font-weight:bold; }
form input, form select { width:100%; padding:8px; margin-top:5px; border:1px solid #ccc; border-radius:5px; }
button { margin-top:30px; padding:10px 15px; background:#28a745; color:#fff; border:none; border-radius:5px; cursor:pointer; font-weight:bold; width:100%;}
button:hover { background:#218838; }
.msg { margin-top:15px; font-weight:bold; color:green; text-align:center; }
.flex { display:flex; gap:10px; }
.flex > div { flex:1; }
</style>
</head>
<body>
<div class="container">
    <h1>Registrar Movimento</h1>

    <!-- Botão Voltar -->
    <a href="dashboard.php" style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#007bff; color:#fff; text-decoration:none; border-radius:5px;">⬅ Voltar ao Dashboard</a>

    <?php if($msg): ?><p class="msg"><?= $msg ?></p><?php endif; ?>

    <form method="POST">
        <label>Tipo do Movimento</label>
        <select name="tipo" required>
            <option value="">-- Selecione --</option>
            <option value="entrada">Entrada</option>
            <option value="saida">Saída</option>
        </select>

        <label>Descrição</label>
        <input type="text" name="descricao" required>

        <div class="flex">
            <div>
                <label>Valor (R$)</label>
                <input type="text" name="valor" required>
            </div>
            <div>
                <label>Data</label>
                <input type="date" name="data_movimento" value="<?= date('Y-m-d') ?>" required>
            </div>
        </div>

        <label>Meio de Pagamento</label>
        <select name="meio_pagamento" required>
            <option value="">-- Selecione --</option>
            <option value="Em mãos">Em mãos</option>
            <option value="Iugu">Iugu</option>
            <option value="Itau">Itau</option>
        </select>

        <button type="submit" name="salvar">Salvar</button>
    </form>
</div>

</body>
</html>
