<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$id = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM provisoes WHERE id=? AND usuario_id=?");
$stmt->execute([$id, $usuario_id]);
$provisao = $stmt->fetch();

if(!$provisao){
    die("Provisão não encontrada!");
}

$msg = "";

if(isset($_POST['atualizar'])){
    $descricao = trim($_POST['descricao']);
    $valor = floatval($_POST['valor']);
    $data_prevista = $_POST['data_prevista'];
    $status = $_POST['status'];

    $stmt = $pdo->prepare("UPDATE provisoes SET descricao=?, valor=?, data_prevista=?, status=? WHERE id=? AND usuario_id=?");
    $stmt->execute([$descricao, $valor, $data_prevista, $status, $id, $usuario_id]);

    $msg = "✅ Provisão atualizada!";
    // recarregar dados
    $stmt->execute([$id, $usuario_id]);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Editar Provisão</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
    <h1>Editar Provisão</h1>
    <a href="provisoes.php">⬅ Voltar</a>
    <?php if($msg): ?><p><?= $msg ?></p><?php endif; ?>
    <form method="POST">
        <input type="text" name="descricao" value="<?= htmlspecialchars($provisao['descricao']) ?>" required><br>
        <input type="number" step="0.01" name="valor" value="<?= $provisao['valor'] ?>" required><br>
        <input type="date" name="data_prevista" value="<?= $provisao['data_prevista'] ?>" required><br>
        <select name="status">
            <option value="pendente" <?= $provisao['status']=='pendente'?'selected':'' ?>>Pendente</option>
            <option value="pago" <?= $provisao['status']=='pago'?'selected':'' ?>>Pago</option>
        </select><br><br>
        <button type="submit" name="atualizar">Salvar Alterações</button>
    </form>
</div>
</body>
</html>
