<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$id = $_GET['id'] ?? 0;

$stmt = $pdo->prepare("SELECT * FROM movimentos WHERE id=? AND usuario_id=?");
$stmt->execute([$id, $_SESSION['usuario_id']]);
$mov = $stmt->fetch();

if(!$mov){
    die("Movimento não encontrado.");
}

if(isset($_POST['salvar'])){
    $descricao = $_POST['descricao'];
    $valor = floatval(str_replace(',', '.', $_POST['valor']));
    $data_movimento = $_POST['data_movimento'];
    $tipo = $_POST['tipo'];

    $stmt = $pdo->prepare("UPDATE movimentos SET descricao=?, valor=?, data_movimento=?, tipo=? WHERE id=? AND usuario_id=?");
    $stmt->execute([$descricao, $valor, $data_movimento, $tipo, $id, $_SESSION['usuario_id']]);

    header("Location: dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Editar Movimento</title>
<style>
.container { max-width:500px; margin:30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
label { display:block; margin-top:10px; font-weight:bold;}
input, select { width:100%; padding:8px; margin-top:5px; border:1px solid #ccc; border-radius:5px; }
button { margin-top:15px; padding:10px 15px; background:#007bff; color:#fff; border:none; border-radius:5px; cursor:pointer; font-weight:bold; }
button:hover { background:#0056b3; }
</style>
</head>
<body>
<div class="container">
    <h1>Editar Movimento</h1>
    <form method="POST">
        <label>Descrição:</label>
        <input type="text" name="descricao" value="<?= htmlspecialchars($mov['descricao']) ?>" required>

        <label>Valor (R$):</label>
        <input type="text" name="valor" value="<?= number_format($mov['valor'],2,',','.') ?>" required>

        <label>Data:</label>
        <input type="date" name="data_movimento" value="<?= $mov['data_movimento'] ?>" required>

        <label>Tipo:</label>
        <select name="tipo">
            <option value="entrada" <?= $mov['tipo']=='entrada'?'selected':'' ?>>Entrada</option>
            <option value="saida" <?= $mov['tipo']=='saida'?'selected':'' ?>>Saída</option>
        </select>

        <button type="submit" name="salvar">Salvar</button>
    </form>
</div>
</body>
</html>
