<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$id = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM contas_fixas WHERE id=? AND usuario_id=?");
$stmt->execute([$id, $usuario_id]);
$conta = $stmt->fetch();

if(!$conta){
    die("Conta fixa não encontrada!");
}

$msg = "";

if(isset($_POST['atualizar'])){
    $descricao = trim($_POST['descricao']);
    $valor = floatval($_POST['valor']);
    $dia_vencimento = intval($_POST['dia_vencimento']);

    $stmt = $pdo->prepare("UPDATE contas_fixas SET descricao=?, valor=?, dia_vencimento=? WHERE id=? AND usuario_id=?");
    $stmt->execute([$descricao, $valor, $dia_vencimento, $id, $usuario_id]);

    $msg = "✅ Conta fixa atualizada!";
    // Recarregar dados
    $stmt = $pdo->prepare("SELECT * FROM contas_fixas WHERE id=? AND usuario_id=?");
    $stmt->execute([$id, $usuario_id]);
    $conta = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Editar Conta Fixa</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
    <h1>Editar Conta Fixa</h1>
    <a href="contas_fixas.php">⬅ Voltar</a>
    <?php if($msg): ?><p><?= $msg ?></p><?php endif; ?>
    <form method="POST">
        <input type="text" name="descricao" value="<?= htmlspecialchars($conta['descricao']) ?>" required><br>
        <input type="number" step="0.01" name="valor" value="<?= $conta['valor'] ?>" required><br>
        <input type="number" name="dia_vencimento" min="1" max="31" value="<?= $conta['dia_vencimento'] ?>" required><br>
        <button type="submit" name="atualizar">Salvar Alterações</button>
    </form>
</div>
</body>
</html>
